﻿Imports System.Runtime.InteropServices
Imports System.Windows.Forms.DataVisualization.Charting

Public Class AIM
    Public Shared Property Run_file As String

    'c-header in comments just for reference
    'typedef char const*      ( * get_library_date )( );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_library_date", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_library_date() As IntPtr
    End Function

    'typedef char const*      ( * get_library_time )( );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_library_time", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_library_time() As IntPtr
    End Function

    'typedef int( * open_file)( char const* full_path_name );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="open_file", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function open_file(<MarshalAs(UnmanagedType.LPStr)> full_path_name As String) As Long
    End Function

    'typedef int( * close_file_n)( char const* full_path_name );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="close_file_n", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function close_file_n(<MarshalAs(UnmanagedType.LPStr)> full_path_name As String) As Long
    End Function

    'typedef int( * close_file_i)( int idx );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="close_file_i", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function close_file_i(ByVal idx As Integer) As Long
    End Function

    'typedef char const*      ( * get_vehicle_name                      )( int idx );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_vehicle_name", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_vehicle_name(ByVal idx As Integer) As Long
    End Function

    'typedef char const*      ( * get_track_name                        )( int idx );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_track_name", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_track_name(ByVal idx As Integer) As Long
    End Function

    'typedef char const*      ( * get_racer_name                        )( int idx );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_racer_name", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_racer_name(ByVal idx As Integer) As Long
    End Function

    'typedef char const*      ( * get_championship_name                 )( int idx );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_championship_name", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_championship_name(ByVal idx As Integer) As Long
    End Function

    'typedef char const*      ( * get_venue_type_name                   )( int idx );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_venue_type_name", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_venue_type_name(ByVal idx As Integer) As Long
    End Function

    'typedef struct tm Const* ( * get_date_and_time                     )( int idx );
    '<System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_date_and_time", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_date_and_time(idx As Integer) As tm
    End Function

    'typedef int( * get_laps_count)( int idx );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_laps_count", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_laps_count(ByVal idx As Integer) As Long
    End Function

    'typedef int( * get_lap_info)( int idxf, int idxl, Double* pstart, Double* pduration );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_lap_info", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_lap_info(ByVal idx As Integer, ByVal idxl As Integer, ByRef pstart As Double, ByRef pduration As Double) As Long
    End Function

    'typedef int( * get_channels_count)( int idx );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_channels_count", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_channels_count(ByVal idx As Integer) As Long
    End Function

    'typedef char const*      ( * get_channel_name                      )( int idxf, int idxc );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_channel_name", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_channel_name(ByVal idx As Integer, ByVal idx_chs As Long) As Long
    End Function

    'typedef char const*      ( * get_channel_units                     )( int idxf, int idxc );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_channel_units", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_channel_units(ByVal idx As Integer, ByVal idx_chs As Long) As Long
    End Function

    'typedef int( * get_channel_samples_count)( int idxf, int idxc );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_channel_samples_count", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_channel_samples_count(ByVal idx As Integer, ByVal idx_chs As Long) As Long
    End Function

    'typedef int( * get_channel_samples)( int idxf, int idxc, Double* ptime, Double* pvalues, int cnt );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_channel_samples", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_channel_samples(ByVal idx As Integer, ByVal idx_chs As Long, ByVal ptime As IntPtr, ByVal pvalues As IntPtr, ByVal cnt As Integer) As Long
    End Function

    'typedef int( * get_lap_channel_samples_count)( int idxf, int idxl, int idxc );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_lap_channel_samples_count", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_lap_channel_samples_count(ByVal idx As Integer, ByVal idx_lap As Integer, ByVal idx_chs As Long) As Long
    End Function

    'typedef int( * get_lap_channel_samples)( int idxf, int idxl, int idxc, Double* ptime, Double* pvalues, int cnt );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_lap_channel_samples", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_lap_channel_samples(ByVal idx As Integer, ByVal idx_lap As Integer, ByVal idx_chs As Long, ByVal ptime As IntPtr, ByVal pvalues As IntPtr, ByVal cnt As Integer) As Long
    End Function

    'typedef int( * get_GPS_channels_count)( int idx );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_GPS_channels_count", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_GPS_channels_count(ByVal idx As Integer) As Long
    End Function

    'typedef char const*      ( * get_GPS_channel_name                  )( int idxf, int idxc );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_GPS_channel_name", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_GPS_channel_name(ByVal idx As Integer, ByVal idx_chs As Long) As Long
    End Function

    'typedef char const*      ( * get_GPS_channel_units                 )( int idxf, int idxc );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_GPS_channel_units", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_GPS_channel_units(ByVal idx As Integer, ByVal idx_chs As Long) As Long
    End Function

    'typedef int( * get_GPS_channel_samples_count)( int idxf, int idxc );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_GPS_channel_samples_count", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_GPS_channel_samples_count(ByVal idx As Integer, ByVal idx_chs As Long) As Long
    End Function

    'typedef int( * get_GPS_channel_samples)( int idxf, int idxc, Double* ptime, Double* pvalues, int cnt );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_GPS_channel_samples", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_GPS_channel_samples(ByVal idx As Integer, ByVal idx_chs As Long, ByVal ptime As IntPtr, ByVal pvalues As IntPtr, ByVal cnt As Integer) As Long
    End Function

    'typedef int( * get_lap_GPS_channel_samples_count)( int idxf, int idxl, int idxc );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_lap_GPS_channel_samples_count", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_lap_GPS_channel_samples_count(ByVal idx As Integer, ByVal idx_lap As Integer, ByVal idx_chs As Long) As Long
    End Function

    'typedef int( * get_lap_GPS_channel_samples)( int idxf, int idxl, int idxc, Double* ptime, Double* pvalues, int cnt );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_lap_GPS_channel_samples", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_lap_GPS_channel_samples(ByVal idx As Integer, idx_lap As Integer, ByVal idx_chs As Long, ByVal ptime As Long, ByVal pvalues As Long, ByVal cnt As Integer) As Long
    End Function

    'typedef int( * get_GPS_raw_channels_count)( int idx );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_GPS_raw_channels_count", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_GPS_raw_channels_count(ByVal idx As Integer) As Long
    End Function

    'typedef char const*      ( * get_GPS_raw_channel_name              )( int idxf, int idxc );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_GPS_raw_channel_name", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_GPS_raw_channel_name(ByVal idx As Integer, ByVal idx_chs As Long) As Long
    End Function

    'typedef char const*      ( * get_GPS_raw_channel_units             )( int idxf, int idxc );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_GPS_raw_channel_units", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_GPS_raw_channel_units(ByVal idx As Integer, ByVal idx_chs As Long) As Long
    End Function

    'typedef int( * get_GPS_raw_channel_samples_count)( int idxf, int idxc );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_GPS_raw_channel_samples_count", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_GPS_raw_channel_samples_count(ByVal idx As Integer, ByVal idx_chs As Long) As Long
    End Function

    'typedef int( * get_GPS_raw_channel_samples)( int idxf, int idxc, Double* ptime, Double* pvalues, int cnt );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_GPS_raw_channel_samples", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_GPS_raw_channel_samples(ByVal idx As Integer, ByVal idx_chs As Long, ByVal ptime As IntPtr, ByVal pvalues As IntPtr, ByVal cnt As Integer) As Long
    End Function

    'typedef int( * get_lap_GPS_raw_channel_samples_count)( int idxf, int idxl, int idxc );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_lap_GPS_raw_channel_samples_count", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_lap_GPS_raw_channel_samples_count(ByVal idx As Integer, ByVal idx_lap As Integer, ByVal idx_chs As Long) As Long
    End Function

    'typedef int( * get_lap_GPS_raw_channel_samples)( int idxf, int idxl, int idxc, Double* ptime, Double* pvalues, int cnt );
    <System.Runtime.InteropServices.DllImport("MatLabXRK-2017-64-ReleaseU.dll", EntryPoint:="get_lap_GPS_raw_channel_samples", ExactSpelling:=True, CharSet:=System.Runtime.InteropServices.CharSet.Ansi, SetLastError:=True, CallingConvention:=CallingConvention.Cdecl)>
    Public Shared Function get_lap_GPS_raw_channel_samples(ByVal idx As Integer, ByVal idx_lap As Integer, ByVal idx_chs As Long, ByVal ptime As IntPtr, ByVal pvalues As IntPtr, ByVal cnt As Integer) As Long
    End Function

    '-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
    ' Types
    '-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+

    Public Structure tm
        Public tm_sec As Integer   ' seconds after the minute - [0, 60] including leap second
        Public tm_min As Integer   ' minutes after the hour - [0, 59]
        Public tm_hour As Integer  ' hours since midnight - [0, 23]
        Public tm_mday As Integer  ' day Of the month - [1, 31]
        Public tm_mon As Integer   ' months since January - [0, 11]
        Public tm_year As Integer  ' years since 1900
        Public tm_wday As Integer  ' days since Sunday - [0, 6]
        Public tm_yday As Integer  ' days since January 1 - [0, 365]
        Public tm_isdst As Integer ' daylight savings time flag
    End Structure

    Public Shared Sub GetLaps()

        Dim sFile As String = ""

        AIMDatabase.Laps1.Items.Clear()

        Dim idx As Integer = AIM.open_file(Run_file)

        Dim p As Long = AIM.get_racer_name(idx)
        Dim racer_name As String = Marshal.PtrToStringAnsi(p)

        Dim laps_count As Long = AIM.get_laps_count(idx)
        Dim idxl As Integer
        If laps_count < 100 Then
            For idxl = 0 To laps_count
                Dim start As Double = 0.0
                Dim duration As Double = 0.0
                If AIM.get_lap_info(idx, idxl, start, duration) = 1 Then
                    AIMDatabase.Laps1.Items.Add("Lap " & idxl & " - " & duration)
                End If
            Next
        End If

        GetLapsChannels(idx)

        p = AIM.close_file_i(idx)

    End Sub

    Public Shared Sub GetLapsChannels(idx As Integer)

        ' Collect available channels for selection
        Dim cbChannels_Items As ArrayList = New ArrayList()

        ' Get basic channels
        Dim p As Long
        Dim idxc As Integer, channel_name As String ', channel_unit As String
        Dim chs_count As Integer = AIM.get_channels_count(idx)
        Dim src As String = "Basic"
        For idxc = 0 To chs_count
            p = AIM.get_channel_name(idx, idxc)
            channel_name = Marshal.PtrToStringAnsi(p)
            'p = AIM.get_channel_units(idx, idxc)
            'Dim channel_unit As String = Marshal.PtrToStringAnsi(p)
            Debug.Print("Channel " & idxc & " name : " & channel_name) '& " Unit : " & channel_unit)
            If channel_name <> "" Then
                cbChannels_Items.Add(New CboList(idxc, src, channel_name))
            End If
        Next

        'Get GPS channels
        src = "GPS"
        Dim gps_count = AIM.get_GPS_channels_count(idx)
        For idxc = 0 To chs_count
            p = AIM.get_GPS_channel_name(idx, idxc)
            channel_name = Marshal.PtrToStringAnsi(p)
            'p = AIM.get_GPS_channel_units(idx, idxc)
            'channel_unit = Marshal.PtrToStringAnsi(p)
            Debug.Print("GPS Channel " & idxc & " name : " & channel_name) '& " Unit : " & channel_unit)
            If channel_name <> "" Then
                cbChannels_Items.Add(New CboList(idxc, src, channel_name))
            End If
        Next

        Call SetComboValues(AIMDatabase.cbChannels, cbChannels_Items, My.Settings.cbChannels)

    End Sub

    Public Shared Sub GetLapChannelSamples(ByVal BasicChannels As ArrayList, ByVal GPSChannels As ArrayList, sFile As String, idxl As Integer)

        Dim i As Integer = 1
        Dim result As Integer

        Dim idx As Long = open_file(sFile)

        ' Collect data for selected lap
        Debug.Print("Lap : " & CStr(idxl))
        Dim start As Double = 0
        Dim duration As Double = 0
        If (get_lap_info(idx, idxl, start, duration) = 1) Then

            For Each itemc As ID_Code In BasicChannels

                Dim pc As Long = get_channel_name(idx, itemc.id)
                Dim channel_name As String = Marshal.PtrToStringAnsi(pc)

                Dim samples As Integer = get_lap_channel_samples_count(idx, idxl, itemc.id)
                Debug.Print("Basic Channel : " & CStr(itemc.id) & " - " & channel_name & " - " & CStr(samples))

                Dim p_values() As Double = New Double((CType(samples, Long) - 1)) {}
                Dim p_time() As Double = New Double((CType(samples, Long) - 1)) {}

                ' Buffer size
                Dim size As Integer = (Marshal.SizeOf(GetType(Double)) * samples)

                ' Pointers
                Dim pvalues As IntPtr = Marshal.AllocHGlobal(size)
                Dim ptime As IntPtr = Marshal.AllocHGlobal(size)

                result = get_lap_channel_samples(idx, idxl, itemc.id, ptime, pvalues, samples)

                Marshal.Copy(pvalues, p_values, 0, samples)
                Marshal.Copy(ptime, p_time, 0, samples)

                Marshal.FreeHGlobal(pvalues)
                Marshal.FreeHGlobal(ptime)

                ' Do your magic here. Combine results to separate result class and operate in memory
                ' This is just to show collected values :
                DataToGraph(p_time, p_values)

            Next

            For Each itemc As ID_Code In GPSChannels

                Dim channels As Long = get_GPS_channels_count(idx)   ' for some reason this must be done first !!!

                Dim pc As Long = get_GPS_channel_name(idx, itemc.id)
                Dim channel_name As String = Marshal.PtrToStringAnsi(pc)

                Dim samples As Long = get_lap_GPS_channel_samples_count(idx, idxl, itemc.id)
                Debug.Print("GPS Channel : " & CStr(itemc.id) & " - " & channel_name & " - " & CStr(samples))

                Dim p_values() As Double = New Double((CType(samples, Integer) - 1)) {}
                Dim p_time() As Double = New Double((CType(samples, Integer) - 1)) {}

                ' Buffer size
                Dim size As Integer = (Marshal.SizeOf(GetType(UInt64)) * samples)

                ' Pointers
                Dim pvalues As Long = Marshal.AllocHGlobal(size)
                Dim ptime As Long = Marshal.AllocHGlobal(size)

                result = get_lap_GPS_channel_samples(idx, idxl, itemc.id, ptime, pvalues, samples)

                Marshal.Copy(pvalues, p_values, 0, samples)
                Marshal.Copy(ptime, p_time, 0, samples)

                Marshal.FreeHGlobal(pvalues)
                Marshal.FreeHGlobal(ptime)

                ' Do your magic here. Combine results to separate result class and operate in memory
                ' This is just to show collected values :
                DataToGraph(p_time, p_values)

            Next
        End If

        Dim p As Long = AIM.close_file_i(idx)

    End Sub

    Public Shared Sub DataToGraph(p_time() As Double, p_values() As Double)

        AIMDatabase.grph.Series.Clear()
        Dim SeriesID As Integer = 0
        AIMDatabase.grph.Series.Add("Lap Data")
        AIMDatabase.grph.Series(SeriesID).ChartType = SeriesChartType.Line
        AIMDatabase.grph.Series(SeriesID).Color = Color.Blue
        AIMDatabase.grph.Series(SeriesID).BorderWidth = 1
        AIMDatabase.grph.Series(SeriesID).YValuesPerPoint = 1
        AIMDatabase.grph.Series(SeriesID).IsVisibleInLegend = False
        AIMDatabase.grph.Series(SeriesID).Points.DataBindXY(p_time, p_values)

    End Sub

    Public Shared Sub SetComboValues(ByRef MyCombo As ComboBox, DataList As ArrayList, MySetting As String)
        If DataList.Count > 0 Then
            MyCombo.DataSource = DataList
            MyCombo.DisplayMember = "chs_Name"
            MyCombo.ValueMember = "idx_chs"
            If MySetting <> "" Then
                MyCombo.SelectedIndex = (MyCombo.FindString(MySetting))
            Else
                MyCombo.SelectedIndex = -1
            End If
        End If
    End Sub

End Class
