﻿Imports System.Data.OleDb
Imports System.IO

Public Class AIMDatabase

    Dim AIMFile As String = "C:/AIM_SPORT/RaceStudio2/DATABASE/DrkTest_DB_20000.mdb"
    Dim conn As String = "Provider=Microsoft.ACE.OLEDB.12.0;Data Source=" & AIMFile & ";Persist Security Info=False"
    Dim IsLoading As Boolean

    Private Sub AIMDatabase_Load(sender As Object, e As EventArgs) Handles MyBase.Load

        Dim cmd As String
        IsLoading = True

        cmd = "Select [CODICE_VEICOLO] as [ID], [NOME_VEICOLO] as [Name] from TAB_VEICOLI"
        PopulateCombo(cbCarRun1, cmd)

        cmd = "Select [CODICE_PISTA] as [ID], [NOME_PISTA] as [Name] from TAB_PISTE"
        PopulateCombo(cbTrackRun1, cmd)

        cmd = "Select [CODICE_PILOTA] as [ID], [NOME_PILOTA] as [Name] from TAB_PILOTI"
        PopulateCombo(cbDriverRun1, cmd)

        cmd = "Select [CODICE_CAMPIONATO] as [ID], [NOME_CAMPIONATO] as [Name] from TAB_CAMPIONATI"
        PopulateCombo(cbEventRun1, cmd)

        cmd = "Select [CODICE_TIPOPROVA] as [ID], [TIPOPROVE] as [Name] from AIM_TIPOPROVE"
        PopulateCombo(cbTypeRun1, cmd)

        IsLoading = False
        RefreshGrid()

    End Sub

    Private Sub bOK_Click(sender As Object, e As EventArgs) Handles bClose.Click
        Close()
        Dispose()
    End Sub

    Public Shared Sub AddToSelection(ByRef MyCombo As ComboBox, ByRef BasicChannels As ArrayList, ByRef GPSChannels As ArrayList)

        Dim idx_chs As Integer, src As String
        If Not IsNothing(MyCombo.SelectedItem) Then
            idx_chs = DirectCast(MyCombo.SelectedItem, CboList).idx_chs
            src = DirectCast(MyCombo.SelectedItem, CboList).src
            Select Case src
                Case "Basic"
                    BasicChannels.Add(New ID_Code(idx_chs, MyCombo.Name))
                Case "GPS"
                    GPSChannels.Add(New ID_Code(idx_chs, MyCombo.Name))
            End Select
        End If
    End Sub

    Sub RefreshGrid()

        If IsLoading Then Exit Sub

        Dim cmd As String = "SELECT CODICE_PROVA, NOME_FILE, PATH_FILE, NOME_PROVA as [Name], DATAORA_FILE as [Time] FROM TAB_PROVE WHERE 1=1 "

        If cbCarRun1.SelectedIndex <> -1 Then
            If cbCarRun1.SelectedValue <> 0 Then cmd = cmd & "AND CODICE_VEICOLO = " & cbCarRun1.SelectedValue & " "
        End If

        If cbTrackRun1.SelectedIndex <> -1 Then
            If cbTrackRun1.SelectedValue <> 0 Then cmd = cmd & "AND CODICE_PISTA = " & cbTrackRun1.SelectedValue & " "
        End If

        If cbDriverRun1.SelectedIndex <> -1 Then
            If cbDriverRun1.SelectedValue <> 0 Then cmd = cmd & "AND CODICE_PILOTA = " & cbDriverRun1.SelectedValue & " "
        End If

        If cbEventRun1.SelectedIndex <> -1 Then
            If cbEventRun1.SelectedValue <> 0 Then cmd = cmd & "AND CODICE_CAMPIONATO = " & cbEventRun1.SelectedValue & " "
        End If

        If cbTypeRun1.SelectedIndex <> -1 Then
            If cbTypeRun1.SelectedValue <> 0 Then cmd = cmd & "AND CODICE_TIPOPROVA = " & cbTypeRun1.SelectedValue & " "
        End If

        cmd = cmd & "ORDER BY TAB_PROVE.CODICE_PROVA DESC;"
        Call PopulateGrid(grTest1, cmd)

        If My.Settings.Run1Selected <> "" Then
            For Each grow As DataGridViewRow In grTest1.Rows
                If grow.Cells.Item(1).Value = My.Settings.Run1Selected Then
                    grTest1.FirstDisplayedScrollingRowIndex = grTest1.Rows(grow.Index).Index
                    grTest1.Refresh()
                    grTest1.CurrentCell = grow.Cells.Item(3)
                    SelectGrid1Cell()
                    grow.Selected = True
                    Exit For
                End If
            Next
        Else
            grTest1.ClearSelection()
        End If

    End Sub

    Sub PopulateCombo(ByRef MyCombo As ComboBox, cmd As String)
        Dim adapter As New OleDbDataAdapter(cmd, conn)
        Dim TableName As New DataTable
        Dim SelectedValue As String = "None"

        Select Case MyCombo.Name
            Case "cbTrackRun1"
                SelectedValue = My.Settings.cbTrackRun1
            Case "cbCarRun1"
                SelectedValue = My.Settings.cbCarRun1
            Case "cbDriverRun1"
                SelectedValue = My.Settings.cbDriverRun1
            Case "cbTypeRun1"
                SelectedValue = My.Settings.cbTypeRun1
            Case "cbEventRun1"
                SelectedValue = My.Settings.cbEventRun1
        End Select

        adapter.Fill(TableName)
        MyCombo.DataSource = TableName
        MyCombo.DisplayMember = "Name"
        MyCombo.ValueMember = "ID"

        MyCombo.SelectedIndex = (MyCombo.FindString(SelectedValue))

    End Sub

    Sub PopulateGrid(ByRef MyGrid As DataGridView, cmd As String)

        Dim ocon As New OleDbConnection(conn)
        Dim ocmd As New OleDbCommand(cmd, ocon)
        ocon.Open()
        Dim reader As OleDbDataReader = ocmd.ExecuteReader()
        reader.Read()
        ' Debug.Print(reader.HasRows.ToString)
        ' Sometimes reader fails on debbuging at least for unknown reason.

        If reader.HasRows Then
            Dim adapter As New OleDbDataAdapter(cmd, conn)
            Dim TableName As New DataTable
            adapter.Fill(TableName)
            MyGrid.Columns.Clear()
            MyGrid.DataSource = TableName
            MyGrid.Columns.Item(0).Visible = False
            MyGrid.Columns.Item(1).Visible = False
            MyGrid.Columns.Item(2).Visible = False
            MyGrid.Columns.Item(3).FillWeight = 75
            MyGrid.Columns.Item(4).FillWeight = 50
        End If
        reader.Close()

    End Sub

    Private Sub cbTrack1_SelectedIndexChanged(sender As Object, e As EventArgs) Handles cbCarRun1.SelectedIndexChanged, cbTrackRun1.SelectedIndexChanged _
            , cbDriverRun1.SelectedIndexChanged, cbEventRun1.SelectedIndexChanged, cbTypeRun1.SelectedIndexChanged

        Call RefreshGrid()

        Select Case sender.name
            Case "cbTrackRun1"
                My.Settings.cbTrackRun1 = DirectCast(sender.SelectedItem, System.Data.DataRowView).Row.ItemArray(1)
            Case "cbCarRun1"
                My.Settings.cbCarRun1 = DirectCast(sender.SelectedItem, System.Data.DataRowView).Row.ItemArray(1)
            Case "cbDriverRun1"
                My.Settings.cbDriverRun1 = DirectCast(sender.SelectedItem, System.Data.DataRowView).Row.ItemArray(1)
            Case "cbTypeRun1"
                My.Settings.cbTypeRun1 = DirectCast(sender.SelectedItem, System.Data.DataRowView).Row.ItemArray(1)
            Case "cbEventRun1"
                My.Settings.cbEventRun1 = DirectCast(sender.SelectedItem, System.Data.DataRowView).Row.ItemArray(1)
        End Select
        My.Settings.Save()

    End Sub

    Private Sub grTest1_CellClick(sender As Object, e As DataGridViewCellEventArgs) Handles grTest1.CellClick

        SelectGrid1Cell()

    End Sub

    Sub SelectGrid1Cell()

        Dim Row As DataGridViewRow = grTest1.SelectedRows.Item(0)
        Cursor = Cursors.WaitCursor
        AIM.Run_file = Row.Cells(2).Value & Row.Cells(1).Value

        My.Settings.Run1Selected = Row.Cells(1).Value
        My.Settings.Save()

        If File.Exists(AIM.Run_file) Then
            IsLoading = True
            AIM.GetLaps()
            IsLoading = False
        Else
            MsgBox("File (" & AIM.Run_file & ") not found!", MsgBoxStyle.Critical, "Info")
        End If

        Cursor = Cursors.Default
    End Sub

    Private Sub cbChannels_SelectedIndexChanged(sender As Object, e As EventArgs) Handles cbChannels.SelectedIndexChanged
        If IsLoading Then Exit Sub
        My.Settings.cbChannels = DirectCast(cbChannels.SelectedItem, CboList).chs_Name
        My.Settings.Save()
        GetData()
    End Sub

    Protected Overrides Function ProcessCmdKey(ByRef msg As Message, ByVal keyData As Keys) As Boolean
        If keyData = Keys.Delete Then
            Select Case Me.ActiveControl.Name
                Case "cbChannels"
                    cbChannels.SelectedIndex = -1
            End Select
        End If
        Return MyBase.ProcessCmdKey(msg, keyData)
    End Function

    Private Sub Laps1_SelectedIndexChanged(sender As Object, e As EventArgs) Handles Laps1.SelectedIndexChanged
        GetData()
    End Sub

    Sub GetData()

        If cbChannels.SelectedIndex = -1 Then Exit Sub
        If Laps1.SelectedIndex = -1 Then Exit Sub

        Dim BasicChannels As ArrayList = New ArrayList()
        Dim GPSChannels As ArrayList = New ArrayList()

        ' Selected Channel
        AddToSelection(cbChannels, BasicChannels, GPSChannels)

        ' Get lapID
        Dim idxl As Integer = Split(Replace(Laps1.SelectedItem, "Lap ", ""), " - ")(0)

        ' Collect data for selected
        AIM.GetLapChannelSamples(BasicChannels, GPSChannels, AIM.Run_file, idxl)

    End Sub
End Class